﻿using System;
using RimWorld;
using Verse;
using Verse.AI;
using System.Collections.Generic;
using System.Diagnostics;

namespace SimpleSlavery
{
	public class JobDriver_EnslavePrisoner : JobDriver
	{
		const int enslaveDuration = 300;

		private Pawn Victim {
			get {
				return (Pawn)CurJob.GetTarget (TargetIndex.A).Thing;
			}
		}

		private Apparel SlaveCollar {
			get {
				return (Apparel)CurJob.GetTarget (TargetIndex.B).Thing;
			}
		}

		[DebuggerHidden]
		protected override IEnumerable<Toil> MakeNewToils()
		{
			this.FailOnDespawnedOrNull (TargetIndex.A);
			this.FailOnDestroyedOrNull (TargetIndex.B);
			this.FailOnForbidden (TargetIndex.B);
			yield return Toils_Reserve.Reserve (TargetIndex.A);
			yield return Toils_Reserve.Reserve (TargetIndex.B);
			yield return Toils_Goto.GotoThing (TargetIndex.B, PathEndMode.Touch);
			yield return new Toil {
				initAction = delegate {
					pawn.jobs.curJob.count = 1;
				}
			};
			yield return Toils_Haul.StartCarryThing (TargetIndex.B);
			yield return Toils_Goto.GotoThing (TargetIndex.A, PathEndMode.Touch);
			Toil enslave = new Toil();
			enslave.initAction = delegate {
				PawnUtility.ForceWait (Victim, enslaveDuration, pawn, true);
			};
			enslave.defaultDuration = enslaveDuration;
			enslave.WithProgressBarToilDelay(TargetIndex.A, false, -0.5f);
			yield return enslave;
			yield return new Toil
			{
				initAction = delegate
				{
					Thing slaveCollar = null;
					pawn.carryTracker.TryDropCarriedThing(pawn.PositionHeld, ThingPlaceMode.Direct, out slaveCollar, null);
					if(slaveCollar != null){
						SlaveUtility.GiveSlaveCollar(Victim, (Apparel)slaveCollar);
						AddEndCondition (() => JobCondition.Succeeded);
					}
					else
						AddEndCondition (() => JobCondition.Incompletable);
				},
				defaultCompleteMode = ToilCompleteMode.Instant
			};
		}
	}
}

